class XCrade_Invincible extends UT_Invisibility;

#exec obj load file=..\Textures\Belt_fx.utx package=Belt_fx

var int PHealth, PArmor;
var int ShowCharge;
var config int bRespawnTime;

state Activated
{
	function endstate()
		{
		local Inventory S;
		local PlayerPawn P;
		local Bot B;

		if ( Owner.IsA('PlayerPawn'))
			{
			P = PlayerPawn(Owner);
			P.ReducedDamageType = '';
			}
		else
			{
			B = Bot(Owner);
			B.ReducedDamageType = '';
			}

		bActive = false;
		
		PlaySound(DeActivateSound);

		Owner.SetDefaultDisplayProperties();
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			{
			UT_Shieldbelt(S).MyEffect.bHidden = false;
			}
		PHealth = 0;
		PArmor = 0;
		
		}

	function Activate()
		{
		bActive = true;
		SetOwnerDisplay();
		}

	function SetOwnerDisplay()
		{
		if ( !bActive )
			{
			return;
			}

		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield',true,true);
		}

	function ChangedWeapon()
		{
		if ( !bActive )
			{
			return;
			}
		if( Inventory != None )
			{
			Inventory.ChangedWeapon();
			}

		//Now put on some color yeah
		if ( Pawn(Owner).Weapon != None )
			{
			Pawn(Owner).Weapon.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield',true,true);
			}
		}

	function Timer()
	{
		Charge -= 1;
		Pawn(Owner).Visibility = 10;
		Owner.AmbientGlow = 250; 
		Owner.LightEffect=LE_Rotor;//NonIncidence
		Owner.LightBrightness=64;
		Owner.LightHue=170;
		Owner.LightRadius=42;
		Owner.LightSaturation=127;
		Owner.LightType=LT_Steady;
		ShowCharge = Charge;
		if (Charge<-0)
			{
			Owner.AmbientGlow = Owner.Default.AmbientGlow;
			Owner.LightType = LT_None;
			Pawn(Owner).DamageScaling = 1.0;
			UsedUp();
			}
		if ( Charge < 12 && Charge > 0 )
			{
			Owner.PlaySound(Sound'BotPack.ChatSound.NewBeep');
			}
	}

	function BeginState()
	{
		local Inventory S;

		bActive = true;
		PlaySound(ActivateSound,,4.0);

		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent,FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield',false,true);
		SetTimer(0.5,True);
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			{
			UT_Shieldbelt(S).MyEffect.bHidden = true;
			}
	}

	simulated function Tick(float DT) 
	{
	local PlayerPawn P;
	local Bot B;

	if ( Owner.IsA('PlayerPawn'))
		{
		P = PlayerPawn(Owner);
		P.ReducedDamageType = 'All';
		}
	else
		{
		B = Bot(Owner);
		B.ReducedDamageType = 'All';
		}

	Super.Tick(DT);
	
	}
}

state DeActivated
{
Begin:
}

State Sleeping
{
    ignores Touch;

    function BeginState()
    {
        BecomePickup();
        bHidden = true;
    }
    function EndState()
    {
        local int i;

        bSleepTouch = false;
        for ( i=0; i<4; i++ )
            if ( (Touching[i] != None) && Touching[i].IsA('Pawn') )
                bSleepTouch = true;
    }           
Begin:
    Sleep( bReSpawnTime );
    PlaySound( RespawnSound );  
    Sleep( Level.Game.PlaySpawnEffect(self) );
    GoToState( 'Pickup' );
}

defaultproperties
{
     PickupMessage="Woot! you are now invincible!"
     ItemName="XCrade"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'MHXv3.XCrade'
     Charge=200
     PickupSound=Sound'Botpack.CTF.CaptureSound'
     Mesh=Mesh'MHXv3.XCrade'
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'MHXv3.Crades.crade3'
     CollisionRadius=24.000000
     CollisionHeight=24.000000
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
}
